﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Forms;
using NintendoWare.SoundMaker.Framework.Configurations.Schemas;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    public class XmlCommandBarSortedList : SortedList<XmlCommandBar, XmlCommandBar>
    {
        public XmlCommandBarSortedList()
            : base(new XmlCommandBarComparer())
        {
        }

        public void Add(XmlCommandBar item)
        {
            if (null == item) { throw new ArgumentNullException("item"); }
            base.Add(item, item);
        }

        public void AddRange(XmlCommandBar[] items)
        {
            if (null == items) { throw new ArgumentNullException("items"); }

            foreach (XmlCommandBar item in items)
            {
                Add(item);
            }
        }

        private class XmlCommandBarComparer : IComparer<XmlCommandBar>
        {
            public int Compare(XmlCommandBar x, XmlCommandBar y)
            {
                int result = x.CommandBarContainer.CompareTo(y.CommandBarContainer);
                if (0 != result) { return result; }

                switch (x.CommandBarContainer)
                {
                    case XmlCommandBarContainer.Left:
                    case XmlCommandBarContainer.Right:
                        if (x.X < y.X) { return -1; }
                        if (x.X > y.X) { return 1; }
                        if (x.Y < y.Y) { return -1; }
                        if (x.Y > y.Y) { return 1; }
                        return string.Compare(x.Name, y.Name);

                    default:
                    case XmlCommandBarContainer.Top:
                    case XmlCommandBarContainer.Bottom:
                        if (x.Y < y.Y) { return -1; }
                        if (x.Y > y.Y) { return 1; }
                        if (x.X < y.X) { return -1; }
                        if (x.X > y.X) { return 1; }
                        return string.Compare(x.Name, y.Name);
                }
            }
        }
    }
}
