﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Collections.Generic;
using NintendoWare.SoundFoundation.Windows.Forms;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms
{
    public class HeaderConfigurationApplier
    {
        public static void ApplyConfiguration(string listName, IHeaderSource source)
        {
            if (!FormsApplication.Instance.UIService.DefaultHeaderAdapters.ContainsKey(listName))
            {
                return;
            }

            ListHeaderAdapterBase headerAdapter = FormsApplication.Instance.UIService.
                                                  DefaultHeaderAdapters[listName];

            headerAdapter.SortOrder = source.SortOrder;

            List<HeaderColumnData> columns = new List<HeaderColumnData>();

            foreach (IHeaderItem item in source.Items)
            {

                columns.Add(
                    new HeaderColumnData()
                    {
                        Name = item.Name,
                        Length = item.Length,
                        Visible = item.Visible,
                    });

            }

            headerAdapter.Columns = columns.ToArray();

            if (null == source.SortItem)
            {
                headerAdapter.SortItem = null;
            }
            else
            {

                foreach (IHeaderItem item in headerAdapter.Headers)
                {
                    if (item.Name != source.SortItem.Name) { continue; }
                    headerAdapter.SortItem = item;
                    break;
                }

            }
        }
    }
}
