﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Windows.Forms.CommandHandlers
{
    using System;
    using NintendoWare.SoundFoundation.CommandHandlers;
    using NintendoWare.SoundFoundation.Commands;

    /// <summary>
    /// ツールページを表示します。
    /// </summary>
    public class ShowToolPageHandler : CommandHandler
    {
        public delegate bool QueryStatusHandlerDelegate(ref CommandStatus status);

        private QueryStatusHandlerDelegate queryStatusHandlerDelegate;

        private string _targetCommandID;
        private string _toolPageName;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="targetCommandID">処理対象コマンドID。</param>
        /// <param name="toolPageName">対象ツールページ名。</param>
        public ShowToolPageHandler(string targetCommandID, string toolPageName)
        {
            if (null == targetCommandID) { throw new ArgumentNullException("targetCommandID"); }
            if (null == toolPageName) { throw new ArgumentNullException("toolPageName"); }
            if (0 == toolPageName.Length) { throw new ArgumentException("invalid toolPageName."); }

            _targetCommandID = targetCommandID;
            _toolPageName = toolPageName;
        }

        public override string TargetCommandID
        {
            get { return _targetCommandID; }
        }

        public void SetQueryStatusHandler(QueryStatusHandlerDelegate handler)
        {
            this.queryStatusHandlerDelegate = handler;
        }

        private MainWindow MainWindow
        {
            get { return FormsApplication.Instance.UIService.MainWindow; }
        }

        ///--------------------------------
        /// <summary>
        /// コマンドを実行できるかどうか調べる
        /// </summary>
        protected override CommandStatus QueryStatusInternal(Command command, IQueryCommandParameter parameters)
        {
            if (MainWindow.ToolPages.ContainsKey(_toolPageName) == false)
            {
                return CommandStatus.SupportedAndVisible;
            }

            IToolWindowPage windowPage = MainWindow.ToolPages[_toolPageName];

            if (this.queryStatusHandlerDelegate != null)
            {
                CommandStatus status = CommandStatus.Unsupported;

                if (this.queryStatusHandlerDelegate(ref status) == true)
                {
                    return status;
                }
            }

            return windowPage.DockVisible != false ?
                CommandStatus.SupportedAndEnabledAndVisible | CommandStatus.Checked :
                CommandStatus.SupportedAndEnabledAndVisible;
        }

        ///--------------------------------
        /// <summary>
        /// コマンドの実行
        /// </summary>
        protected override bool ExecuteInternal(Command command, IQueryCommandParameter parameters)
        {
            IToolWindowPage windowPage = MainWindow.ToolPages[_toolPageName];
            if (windowPage.DockVisible == false)
            {
                MainWindow.ActivateToolPage(windowPage);
            }
            else
            {
                windowPage.DockVisible = false;
            }
            return true;
        }
    }
}
