﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Windows.Forms;
using NintendoWare.SoundFoundation.Commands;
using NintendoWare.SoundFoundation.Projects;
using NintendoWare.SoundMaker.Framework.CommandHandlers;

namespace NintendoWare.SoundMaker.Framework.Windows.Forms.CommandHandlers
{
    /// <summary>
    /// プロジェクト作成ウィザードを使用してプロジェクトを作成します。
    /// </summary>
    public class QueryAndNewProjectHandler : NewProjectHandler
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="queryTarget">対象の問い合わせ先。</param>
        public QueryAndNewProjectHandler(IQueryCommandParameter queryParameter) : base(queryParameter) { }

        /// <summary>
        /// コマンドを実行します。
        /// </summary>
        /// <returns>実行した場合は true、実行しなかった、キャンセルした場合は false。</returns>
        protected override bool ExecuteInternal(Command command, IQueryCommandParameter parameters)
        {
            SoundProjectService projectService = GetTargetProjectService(parameters);
            if (null == projectService) { return false; }

            ProjectCreateWizard wizard = new ProjectCreateWizard();

            if (wizard.ShowDialog() != DialogResult.OK)
            {
                return false;
            }


            if (null != projectService.ProjectDocument)
            {
                if (!CloseProjectHandler.Execute()) { return false; }
            }

            bool result = NewProject(projectService, wizard.ProjectFilePath);
            if (!result) { return false; }

            if (wizard.DoCreateSoundSet)
            {
                result = AddNewSoundSet(projectService, wizard.SoundSetFilePath);
            }
            else if (wizard.DoSpecifySoundSet == true)
            {
                if (wizard.OldVersionFilePaths != null)
                {
                    SaveHelper.SaveForce(wizard.OldVersionFilePaths);
                }

                result = AddExistingSoundSet(projectService, wizard.SoundSetFilePath);
            }

            if (!result) { return false; }

            Application.DocumentService.SaveDocument(projectService.ProjectDocument);

            return true;
        }
    }
}
