﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Utilities
{
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundMaker.Framework.Windows.Forms;
    using System.Collections.Generic;
    using System.Linq;

    public static class SoundSetUtility
    {
        public static IEnumerable<PlayerBase> GetPlayers(IEnumerable<SoundSet> soundSets)
        {
            return soundSets
                .SelectMany<SoundSet, Component>(s => s.Children)
                .Where(c => c is PlayerPack)
                .SelectMany<Component, Component>(p => p.Children)
                .OfType<PlayerBase>();
        }

        public static IEnumerable<SoundSetBankBase> GetSoundSetBanks(IEnumerable<SoundSet> soundSets)
        {
            return soundSets
                .SelectMany<SoundSet, Component>(s => s.Children)
                .Where(c => c is SoundSetBankPack)
                .SelectMany<Component, Component>(p => p.Children)
                .OfType<SoundSetBankBase>();
        }

        public static IEnumerable<WaveArchiveBase> GetWaveArchives(IEnumerable<SoundSet> soundSets)
        {
            return soundSets
                .SelectMany<SoundSet, Component>(s => s.Children)
                .Where(c => c is WaveArchivePack)
                .SelectMany<Component, Component>(p => p.Children)
                .OfType<WaveArchiveBase>();
        }

        public static IEnumerable<SoundSetItem> GetSoundSetItems(IEnumerable<SoundSet> soundSets)
        {
            return soundSets
                .SelectMany<SoundSet, Component>(s => s.Children)
                .Where(c => c is SoundSetItemPack)
                .SelectMany<Component, Component>(p =>
                    {
                        if (p is WaveSoundSetPack || p is SequenceSoundSetPack)
                        {
                            return p.Children
                                .SelectMany<Component, Component>(c => Enumerable.Concat(new[] { c }, c.Children));
                        }
                        else
                        {
                            return p.Children;
                        }
                    })
                .OfType<SoundSetItem>();
        }
    }
}
