﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.IO;

namespace NintendoWare.SoundMaker.Framework.Utilities
{
    using NintendoWare.SoundFoundation.Core.Resources;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundMaker.Framework.Resources;
    using NintendoWare.SoundMaker.Framework.Windows;
    using NintendoWare.SoundMaker.Framework.Windows.Forms;

    public static class ProjectFilePathUtility
    {
        /// <summary>
        ///
        /// </summary>
        public static bool Inquire(IAdapterManipulator adapter, Component targetComponent, string name, object value)
        {
            // falseを返すことによりSetValue()の処理を継続させます。
            return !ConfirmFilePath((string)value);
        }

        /// <summary>
        ///
        /// </summary>
        public static bool ConfirmFilePath(string filePath)
        {
            FormsApplication app = FormsApplication.Instance;
            FileResource resource = app.ProjectService.ProjectDocument.Resource as FileResource;
            return ConfirmFilePath(resource.FilePath, filePath);
        }

        /// <summary>
        ///
        /// </summary>
        public static bool ConfirmFilePath(string cardinalFilePath, string filePath)
        {
            filePath = Path.GetFullPath(filePath);
            FormsApplication app = FormsApplication.Instance;

            if (FilePathIsOutside(cardinalFilePath, filePath) == true)
            {
                if (app.UIService.ShowMessageBox
                    (MessageResource.Message_ConfirmFilePathIsOutsideTheProject,
                      MessageResource.DialogTitle_ConfirmFilePathIsOutsideTheProject,
                      AppMessageBoxButton.YesNo,
                      AppMessageBoxImage.Warning) != AppMessageBoxResult.Yes)
                {
                    return false;
                }
            }

            return true;
        }

        /// <summary>
        ///
        /// </summary>
        private static bool FilePathIsOutside(string cardinalFilePath, string filePath)
        {
            string cardinalDirectory = Path.GetDirectoryName(Path.GetFullPath(cardinalFilePath));
            string directory = Path.GetDirectoryName(Path.GetFullPath(filePath));

            char[] splitCodes = new char[] { '\\', '/' };
            string[] a = cardinalDirectory.Split(splitCodes);
            string[] b = directory.Split(splitCodes);
            if (a.Length > b.Length)
            {
                return true;
            }

            for (int index = 0; index < a.Length; index++)
            {
                if (String.Compare(a[index], b[index], true) != 0)
                {
                    return true;
                }
            }

            return false;
        }
    }
}
