﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundMaker.Framework.Projects
{
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundMaker.Framework.FileFormats;

    public static class StreamSoundTrackEx
    {
        public static bool IsAACFile(this StreamSoundTrackBase streamSoundTrack)
        {
            return AACUtil.IsAACFile(streamSoundTrack.FilePath);
        }

        public static bool IsMultiChannelAACTrack(this StreamSoundTrackBase streamSoundTrack)
        {
            if (AppConfiguration.EnabledMultiChannelAAC == false)
            {
                return false;
            }

            StreamSoundBase streamSound = streamSoundTrack.Parent as StreamSoundBase;

            return streamSound.IsMultiChannelAAC();
        }
    }
}
