﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Collections.Generic;
using System.Linq;

namespace NintendoWare.SoundMaker.Preview.Service
{
    using NintendoWare.SoundFoundation.Projects;

    /// <summary>
    ///
    /// </summary>
    public partial class RealtimeEditService
    {
        /// コンバート中にコンバート要求されたComponentを保存用です。
        private HashSet<Component> convertQueryHashSet = new HashSet<Component>();

        /// <summary>
        ///
        /// </summary>

        /// <summary>
        /// コンバートの要求情報をクリアします。
        /// </summary>
        private void ClearConvertQuery()
        {
            this.convertQueryHashSet.Clear();
        }

        /// <summary>
        /// コンバートの要求情報を追加します。
        /// </summary>
        private void AddConvertQuery(Component component)
        {
            if (this.convertQueryHashSet.Contains(component) == false)
            {
                this.convertQueryHashSet.Add(component);
            }
        }

        /// <summary>
        /// コンバートの要求情報を削除します。
        /// </summary>
        private void RemoveConvertQuery(Component component)
        {
            if (this.convertQueryHashSet.Contains(component) == true)
            {
                this.convertQueryHashSet.Remove(component);
            }
        }

        /// <summary>
        ///
        /// </summary>
        private void ExecuteAllConvertQuery()
        {
            if (Enabled == false)
            {
                return;
            }

            Component[] components = this.convertQueryHashSet.ToArray();
            ClearConvertQuery();

            foreach (Component component in components)
            {
                this.ModifyMonitoringTargetInfo(component);
            }
        }

        /// <summary>
        ///
        /// </summary>
        private delegate void ConvertQueryExecuter(Component component);

        private void ExecuteConvertQuery(Component component, ConvertQueryExecuter executer)
        {
            if (this.convertQueryHashSet.Contains(component) != false)
            {
                this.convertQueryHashSet.Remove(component);
                executer(component);
            }
        }
    }
}
