﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Diagnostics;
using NW4R.ProtocolSound;

namespace NintendoWare.SoundMaker.Framework.Preview.Communications
{
    using NintendoWare.SoundMaker.Framework.Preview.Communications.Error;

    #region システムエラーパケット
    /// <summary>
    /// システムエラーパケット
    /// <para>
    /// システム関連のエラーパケットのベースクラスです。
    /// </para>
    /// </summary>
    public abstract class SystemErrorPacket : ErrorPacket
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public SystemErrorPacket(CommPacket target) : base(target)
        {
            Debug.Assert(Category == Constants.CATEGORY_SYSTEM, "Category is not system");
        }

        /// <summary>
        /// システムエラーパケットの作成
        /// </summary>
        public static SystemErrorPacket CreateSystemErrorPacket(uint packetType, CommPacket target)
        {
            SystemErrorPacket packet = null;
            switch (packetType)
            {
                case Constants.ERR_SYSTEM_UNKNOWN_COMMAND:
                    packet = new UnknownErrorPacket(target);
                    break;
            }
            return packet;
        }

    }
    #endregion

    #region 未対応パケット
    /// <summary>
    /// 未対応パケット
    /// <para>
    /// 対応していないパケットが届いた際に発行されるエラーパケットです。
    /// </para>
    /// </summary>
    public class UnknownErrorPacket : SystemErrorPacket
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public UnknownErrorPacket(CommPacket target) : base(target) { }

        /// <summary>
        /// パケットタイプ
        /// </summary>
        public override ushort PacketType
        {
            get { return Constants.ERR_SYSTEM_UNKNOWN_COMMAND; }
        }

        //---------------------------------------------------------------------
        /// <summary>
        /// 読み込み
        /// </summary>
        public override void Read(ProtocolSoundReader reader, CommPacketHeader header)
        {
            ErrSystemUnknownCommand packet = new ErrSystemUnknownCommand();
            packet.Read(reader);
            ShowMessage("SystemErrorPacket_UnknownPacket",
                         Target.ToString());
        }
    }
    #endregion
}
