﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Diagnostics;

namespace NintendoWare.SoundMaker.Framework.Preview.Communications.Error
{
    /// <summary>
    /// エラーパケット
    /// <para>
    /// 通信で送受信されるエラーパケットのベースクラスです。
    /// </para>
    /// </summary>
    public abstract class ErrorPacket : CommPacket
    {
        //---------------------------------------------------------------------
        // 公開メンバ
        //---------------------------------------------------------------------
        /// <summary>
        /// エラーパケットの作成
        /// </summary>
        public static ErrorPacket Create(CommPacketHeader header, CommPacket target)
        {
            // 分類分けを行う
            ErrorPacket packet = null;

            switch (header.PacketType & Constants.HEADER_CATEGORY_MASK)
            {
                case Constants.CATEGORY_SYSTEM:
                    packet = SystemErrorPacket.CreateSystemErrorPacket(header.PacketType, target);
                    break;

                case Constants.CATEGORY_3D:
                    packet = S3DErrorPacket.CreatePacket(header.PacketType, target);
                    break;

                case Constants.CATEGORY_SOUND:
                    packet = SoundErrorPacket.CreatePacket(header.PacketType, target);
                    break;
            }

            return packet;
        }

        //---------------------------------------------------------------------
        /// <summary>
        /// 読み込み
        /// </summary>
        public override void Read(ProtocolSoundReader reader, CommPacketHeader header)
        {
            // 必ずサブクラスでエラーに対処する必要がある
            Debug.Assert(false, "Don't call this method");
        }

        //---------------------------------------------------------------------
        /// <summary>
        /// エラーを起こしたパケット
        /// </summary>
        public CommPacket Target { get { return _target; } }

        //---------------------------------------------------------------------
        // 非公開メンバ
        //---------------------------------------------------------------------
        /// <summary>
        /// コンストラクタ
        /// </summary>
        protected ErrorPacket(CommPacket target)
        {
            Debug.Assert(!Reply, "Reply is true");
            Debug.Assert(Error, "Error is false");
            _target = target;
        }

        // エラーを起こしたパケット
        private readonly CommPacket _target;
    }
}
