﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Diagnostics;

namespace NintendoWare.SoundMaker.Framework.Preview.Communications.Error
{
    using NW4R.ProtocolSound;

    #region 3Dエラーパケット
    /// <summary>
    /// 3Dエラーパケット
    /// <para>
    /// 3Dに関するエラーのパケットです。
    /// </para>
    /// </summary>
    public abstract class S3DErrorPacket : ErrorPacket
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public S3DErrorPacket(CommPacket target) : base(target)
        {
            Debug.Assert(Category == Constants.CATEGORY_3D, "Category is not 3D");
        }

        /// <summary>
        /// 3Dエラーパケットの作成
        /// </summary>
        public static S3DErrorPacket CreatePacket(uint packetType, CommPacket target)
        {
            S3DErrorPacket packet = null;
            switch (packetType)
            {
                case Constants.ERR_3D_LOAD:
                    packet = new LoadErrorPacket(target);
                    break;
            }
            return packet;
        }

    }
    #endregion

    #region ロードエラー
    /// <summary>
    /// ロードエラー
    /// <para>
    /// 3Dデータのロードに失敗した際に発行されるエラーパケットです。
    /// </para>
    /// </summary>
    public class LoadErrorPacket : S3DErrorPacket
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public LoadErrorPacket(CommPacket target) : base(target) { }

        /// <summary>
        /// パケットタイプ
        /// </summary>
        public override ushort PacketType
        {
            get { return Constants.ERR_3D_LOAD; }
        }

        /// <summary>
        /// 読み込み
        /// </summary>
        public override void Read(ProtocolSoundReader reader, CommPacketHeader header)
        {
            string[] messageTable = new string[]
                {
#if false
                    GetMessageByResource("MCS3DErrorPacket_LoadFailed"),
                    GetMessageByResource("MCS3DErrorPacket_MAllocFailed"),
                    GetMessageByResource("MCS3DErrorPacket_InvalidData"),
                    GetMessageByResource("MCS3DErrorPacket_ComError"),
#else
                    "3DErrorPacket_LoadFailed",
                    "3DErrorPacket_MAllocFailed",
                    "3DErrorPacket_InvalidData",
                    "3DErrorPacket_ComError",
#endif
                };

            Err3DLoad packet = new Err3DLoad();
            packet.Read(reader);
            ShowError(messageTable[(int)packet.code]);
        }
    }
    #endregion
}
