﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using NintendoWare.SoundFoundation;
using NintendoWare.SoundMaker.Framework;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using Schemas = NintendoWare.SoundMaker.Framework.Configurations.Schemas;

namespace NintendoWare.SoundMaker.Framework
{
    public class StatisticsConfiguration : ConfigurationBase
    {
        private const string Platform = Platforms.Any.PlatformName;
        private const string Version = "1.0.0.0";

        private Schemas.XmlStatisticsConfiguration xmlStatisticsConfiguration = null;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public StatisticsConfiguration() :
            base(Platform, Version)
        {
        }

        /// <summary>
        /// 統計を取得します。
        /// </summary>
        public Schemas.XmlStatisticsConfiguration Statistics
        {
            get { return this.xmlStatisticsConfiguration; }
            set { this.xmlStatisticsConfiguration = value; }
        }

        /// <summary>
        /// デフォルト設定を読み込みます。
        /// </summary>
        /// <param name="settings">XmlReader 設定。</param>
        /// <param name="forced">現在の設定を全て破棄する場合は true、読み込み済みの設定を残す場合は false。</param>
        protected override void LoadDefaultsInternal(XmlReaderSettings settings, bool forced)
        {
        }

        /// <summary>
        /// コンフィギュレーション要素を書き出します。
        /// </summary>
        /// <param name="reader">XmlReader。</param>
        /// <param name="basePath">基準パス。</param>
        protected override void WriteConfigurationElements(XmlWriter writer, string basePath)
        {
            if (writer == null) { throw new ArgumentNullException("writer"); }
            if (basePath == null) { throw new ArgumentNullException("basePath"); }

            WriteConfigurationPart<Schemas.XmlStatisticsConfiguration>(writer, this.xmlStatisticsConfiguration);
        }

        /// <summary>
        /// コンフィギュレーションルートを書き出します。
        /// </summary>
        /// <param name="writer">XmlWriter。</param>
        protected override void WriteStartConfigurationRoot(XmlWriter writer)
        {
            base.WriteStartConfigurationRoot(writer);

            writer.WriteAttributeString("xmlns", "nwss", null, "NintendoWare.SoundMaker.StatisticsConfiguration");
        }

        /// <summary>
        /// コンフィギュレーション要素を読み込みます。
        /// </summary>
        /// <param name="xmlElement">コンフィギュレーション要素。</param>
        /// <param name="basePath">基準パス。</param>
        protected override void ReadConfigurationElement(XmlElement xmlElement, string basePath)
        {
            if (xmlElement == null) { throw new ArgumentNullException("xmlElement"); }

            if (xmlElement.LocalName == "StatisticsConfiguration")
            {
                this.xmlStatisticsConfiguration = ReadConfigurationPart<Schemas.XmlStatisticsConfiguration>(xmlElement.OuterXml);
            }
        }

        protected override string RootElementName
        {
            get { return "StatisticsConfiguration"; }
        }
    }
}
