﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.Generic;

namespace NintendoWare.SoundMaker.Framework.Configurations.Schemas
{
    /// <summary>
    /// 全ての TreeNode 設定を格納します。
    /// </summary>
    public partial class XmlTreeNodes
    {
        /// <summary>
        /// XmlTreeNodes に含まれる全 XmlTreeNode の一覧を取得します。
        /// </summary>
        /// <returns>全 XmlTreeNode が含まれたディクショナリ。</returns>
        public IDictionary<string, XmlTreeNode> CreateDictionary()
        {
            Dictionary<string, XmlTreeNode> result = new Dictionary<string, XmlTreeNode>();
            if (null == TreeNode) { return result; }

            foreach (XmlTreeNode xmlTreeNode in TreeNode)
            {
                result.Add(xmlTreeNode.Name, xmlTreeNode);
            }

            return result;
        }
    }
}
