﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundMaker.Framework.Configurations.Schemas
{
    using System;
    using System.Collections.Generic;
    using NintendoWare.ToolDevelopmentKit;

    public static class XmlMidiDeviceEx
    {
        /// <summary>
        /// XmlMidiInputDevices に含まれる全 XmlMidiInputDevice の一覧を取得します。
        /// </summary>
        /// <returns>全 XmlMidiInputDevice が含まれたディクショナリ。</returns>
        public static IDictionary<string, XmlMidiDevice> CreateDictionary(this XmlMidiDevice[] devices)
        {
            Dictionary<string, XmlMidiDevice> result = new Dictionary<string, XmlMidiDevice>();

            if (devices == null)
            {
                return result;
            }

            foreach (XmlMidiDevice xmlMidiDevice in devices)
            {
                result.Add(xmlMidiDevice.Name, xmlMidiDevice);
            }

            return result;
        }
    }
}
