﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework
{
    using SoundFoundation;
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Xml;
    using Schemas = Configurations.Schemas;

    public class PresetListColumnsConfiguration : ConfigurationBase
    {
        private Schemas.XmlPresetListColumnsConfiguration xmlPresetListColumnsConfiguration = null;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public PresetListColumnsConfiguration() :
            base(Platforms.Any.PlatformName, "1.0.0.0")
        {
        }

        /// <summary>
        /// プリセットを取得します。
        /// </summary>
        public Schemas.XmlPresetListColumnsConfiguration PresetList
        {
            get { return this.xmlPresetListColumnsConfiguration; }
            set { this.xmlPresetListColumnsConfiguration = value; }
        }

        /// <summary>
        /// デフォルト設定を読み込みます。
        /// </summary>
        /// <param name="settings">XmlReader 設定。</param>
        /// <param name="forced">現在の設定を全て破棄する場合は true、読み込み済みの設定を残す場合は false。</param>
        protected override void LoadDefaultsInternal(XmlReaderSettings settings, bool forced)
        {
        }

        /// <summary>
        /// コンフィギュレーション要素を書き出します。
        /// </summary>
        /// <param name="reader">XmlReader。</param>
        /// <param name="basePath">基準パス。</param>
        protected override void WriteConfigurationElements(XmlWriter writer, string basePath)
        {
            if (null == writer) { throw new ArgumentNullException("writer"); }
            if (null == basePath) { throw new ArgumentNullException("basePath"); }

            WriteConfigurationPart<Schemas.XmlPresetListColumnsConfiguration>(writer, this.xmlPresetListColumnsConfiguration);
        }

        /// <summary>
        /// コンフィギュレーションルートを書き出します。
        /// </summary>
        /// <param name="writer">XmlWriter。</param>
        protected override void WriteStartConfigurationRoot(XmlWriter writer)
        {
            base.WriteStartConfigurationRoot(writer);

            writer.WriteAttributeString("xmlns", "nwplc", null, "NintendoWare.SoundMaker.PresetListColumnsConfiguration");
        }

        /// <summary>
        /// コンフィギュレーション要素を読み込みます。
        /// </summary>
        /// <param name="xmlElement">コンフィギュレーション要素。</param>
        /// <param name="basePath">基準パス。</param>
        protected override void ReadConfigurationElement(XmlElement xmlElement, string basePath)
        {
            if (null == xmlElement) { throw new ArgumentNullException("xmlElement"); }

            if (xmlElement.LocalName == "PresetListColumnsConfiguration")
            {
                this.xmlPresetListColumnsConfiguration = ReadConfigurationPart<Schemas.XmlPresetListColumnsConfiguration>(xmlElement.OuterXml);
            }
        }

        protected override string RootElementName
        {
            get { return "PresetListColumnsConfiguration"; }
        }
    }
}
