﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;

namespace NintendoWare.SoundMaker.Framework.Configurations
{
    /// <summary>
    /// リストカラムの特性を表します。
    /// </summary>
    public class ListColumnTrait
    {
        private string _name;
        private string _text;
        private int _length;
        private int _minimumLength;
        private int _maximumLength;
        private HorizontalAlignment _alignment;

        public ListColumnTrait(string name, string text, int length,
                                HorizontalAlignment alignment) : this(name, text, length, 0, int.MaxValue, alignment)
        {
        }

        public ListColumnTrait(string name, string text, int length, int minimumLength, HorizontalAlignment alignment) : this(name, text, length, minimumLength, int.MaxValue, alignment)
        {
        }

        public ListColumnTrait(string name, string text, int length, int minimumLength, int maximumLength, HorizontalAlignment alignment)
        {
            if (null == name) { throw new ArgumentNullException("name"); }
            if (null == text) { throw new ArgumentNullException("text"); }
            _name = name;
            _text = text;
            _length = length;
            _alignment = alignment;
            _minimumLength = minimumLength;
            _maximumLength = maximumLength;
        }

        public string Name
        {
            get { return _name; }
        }

        public string Text
        {
            get { return _text; }
        }

        public int Length
        {
            get { return _length; }
        }

        public int MinimumLength
        {
            get { return _minimumLength; }
        }

        public int MaximumLength
        {
            get { return _maximumLength; }
        }

        public HorizontalAlignment Alignment
        {
            get { return _alignment; }
        }

        public enum HorizontalAlignment
        {
            Left,
            Center,
            Right,
        }
    }

}
