﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Framework.Commands
{
    using System.Collections.Generic;
    using System.Reflection;
    using NintendoWare.SoundFoundation.Commands;
    using NintendoWare.SoundFoundation.Core.Drawing;
    using NintendoWare.SoundFoundation.Core.Reflection;
    using NintendoWare.SoundMaker.Framework.Resources;
    using NintendoWare.SoundMaker.Framework.Windows;

    /// <summary>
    /// タブ関連コマンドを管理します。
    /// </summary>
    public static class TabCommands
    {
        /// <summary>
        /// タブ関連コマンドを列挙する IEnumerable を取得します。
        /// </summary>
        public static IEnumerable<Command> Commands
        {
            get
            {
                return ObjectFinder.FindStaticValues<Command>(typeof(TabCommands),
                                                               BindingFlags.GetProperty | BindingFlags.GetField);
            }
        }

        /// <summary>
        /// タブを選択する。
        /// </summary>
        public static readonly Command SelectDocument = new Command("Tab.SelectDocument", string.Empty)
        {
#if false
            Text = string.Empty
#endif
        };

        /// <summary>
        /// 次のタブを選択する。
        /// </summary>
        public static readonly Command NextDocument = new Command("Tab.NextDocument", string.Empty)
        {
#if false
            Text = string.Empty
#endif
        };

        /// <summary>
        /// 前のタブを選択する。
        /// </summary>
        public static readonly Command PreviousDocument = new Command("Tab.PreviousDocument", string.Empty)
        {
#if false
            Text = string.Empty
#endif
        };

        /// <summary>
        /// 閉じる。
        /// </summary>
        public static readonly Command CloseDocument = new Command("Tab.CloseDocument", string.Empty)
        {
#if false
            Text = MessageResource.Command_Tab_CloseDocument_Text
#endif
        };

        /// <summary>
        /// 選択中のタブを閉じる。
        /// </summary>
        public static readonly Command CloseSelectedDocument = new Command("Tab.CloseSelectedDocument", string.Empty)
        {
#if false
            Text = string.Empty
#endif
        };

        /// <summary>
        /// 他のタブをすべて閉じる。
        /// </summary>
        public static readonly Command CloseOtherDocuments = new Command("Tab.CloseOtherDocuments", string.Empty)
        {
#if false
            Text = MessageResource.Command_Tab_CloseOtherDocuments_Text
#endif
        };

        /// <summary>
        /// タブをすべて閉じる。
        /// </summary>
        public static readonly Command CloseAllDocuments = new Command("Tab.CloseAllDocuments", string.Empty)
        {
#if false
            Text = MessageResource.Command_Tab_CloseAllDocuments_Text
#endif
        };

        /// <summary>
        /// フォルダを開く。
        /// </summary>
        public static readonly Command OpenDocumentFolder = new Command("Tab.OpenDocumentFolder", string.Empty)
        {
#if false
            Text = MessageResource.Command_Tab_OpenDocumentFolder_Text,
#endif
            Image = ImageResource.BitmapIconOpenItemFolder.MakeNewTransparent(UIServiceBase.TransparentColor),
        };

        /// <summary>
        /// ブックマークの追加
        /// </summary>
        public static readonly Command AddBookmark = new Command("Tab.AddBookmark", string.Empty)
        {
        };
    }
}
