﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using NintendoWare.SoundFoundation.CommandHandlers;
using NintendoWare.SoundFoundation.Commands;

namespace NintendoWare.SoundMaker.Framework.CommandHandlers
{
    /// <summary>
    /// 指定コマンドを常に無効化します。
    /// </summary>
    public class DisableCommandHandler : CommandHandler
    {
        private string _commandID;
        private CommandStatus _status = CommandStatus.Supported;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="command">対象コマンドID。</param>
        public DisableCommandHandler(string commandID, CommandStatus status)
        {
            if (null == commandID) { throw new ArgumentNullException("command"); }
            if ((status & CommandStatus.Enabled) != 0)
            {
                throw new ArgumentException("invalid status");
            }

            _commandID = commandID;
            _status = status;
        }

        public override string TargetCommandID
        {
            get { return _commandID; }
        }

        public CommandStatus Status
        {
            get { return _status; }
        }

        protected override CommandStatus QueryStatusInternal(Command command, IQueryCommandParameter parameters)
        {
            return _status;
        }

        protected override bool ExecuteInternal(Command command, IQueryCommandParameter parameters)
        {
            return false;
        }
    }
}
