﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;

namespace NintendoWare.SoundMaker.Windows.Forms
{
    /// <summary>
    /// プリセットアイテムイベントデータを格納します。
    /// </summary>
    public class PresetItemEventArgs : EventArgs
    {
        private string _itemName;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="itemName">プリセットアイテム名。</param>
        public PresetItemEventArgs(string itemName)
        {
            if (null == itemName) { throw new ArgumentNullException("itemName"); }
            _itemName = itemName;
        }

        /// <summary>
        /// プリセットアイテム名を取得します。
        /// </summary>
        public string ItemName
        {
            get { return _itemName; }
        }
    }
}
