﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Windows.Forms.CommandHandlers
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Windows.Forms;
    using NintendoWare.SoundFoundation.Commands;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundMaker.Configurations;
    using NintendoWare.SoundMaker.Framework;
    using NintendoWare.SoundMaker.Framework.CommandHandlers;
    using NintendoWare.SoundMaker.Framework.FileFormats;
    using NintendoWare.SoundMaker.Framework.Projects;
    using NintendoWare.SoundMaker.Framework.Windows;
    using NintendoWare.SoundMaker.Framework.Windows.Forms;
    using NintendoWare.SoundMaker.Resources;

    public class SoundListQueryAndAddStreamSoundTrackHandlerCommon : SoundListQueryAndAddStreamSoundTrackHandler
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="insert">挿入する場合は false、追加する場合は false。</param>
        /// <param name="queryTarget">対象の問い合わせ先。</param>
        public SoundListQueryAndAddStreamSoundTrackHandlerCommon(bool insert, IQueryCommandParameter queryParameter)
            : base(insert, queryParameter)
        {
        }

        /// <summary>
        /// コマンドを実行できるかどうか調べます。
        /// </summary>
        /// <returns>コマンドの状態。</returns>
        protected override CommandStatus QueryStatusInternal(Command command, IQueryCommandParameter parameters)
        {
            CommandStatus status = base.QueryStatusInternal(command, parameters);

            StreamSoundBase streamSound = GetTargetStreamSound(parameters);
            if (streamSound.Children.Count == 1 &&
                FileUtil.IsOpusFile((streamSound.Children[0] as StreamSoundTrackBase).FilePath) == true)
            {
                return CommandStatus.SupportedAndVisible;
            }

            return status;
        }

        /// <summary>
        /// コマンドを実行します。
        /// </summary>
        /// <returns>実行した場合は true、実行しなかった、キャンセルした場合は false。</returns>
        protected override bool ExecuteInternal(Command command, IQueryCommandParameter parameters)
        {
            StreamSoundBase streamSound = GetInsertParentComponent(parameters) as StreamSoundBase;
            CreateStreamSoundTrackDialog form = new CreateStreamSoundTrackDialog(this.GetFirstTrackFilePath(streamSound));

            if (form.ShowDialog() != DialogResult.OK)
            {
                return false;
            }

            if (!Execute(parameters, form.NewTrack)) { return false; }

            (Application.UIService as FormsUIService).MainWindow.ShowPageByComponent(form.NewTrack);
            return true;
        }

        private string GetFirstTrackFilePath(StreamSoundBase streamSound)
        {
            StreamSoundTrackBase track = streamSound.Children[0] as StreamSoundTrackBase;

            return track.FilePath;
        }
    }
}
