﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundMaker.Preview
{
    using System;
    using System.Collections;
    using System.Diagnostics;
    using System.IO;
    using System.Reflection;
    using System.Windows.Forms;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.SoundMaker;

    public static class SoundPlayerWin
    {
        ///--------------------------------
        /// <summary>
        /// サウンドプレイヤーの起動
        /// </summary>
        public static void Start(string dvdRootPath,
                                 int port0,
                                 int port1,
                                 int port2,
                                 int port3,
                                 int port4,
                                 int port5,
                                 SoundProjectDocument projectDocument,
                                 string soundPlayerDirectoryPath)
        {
            if (null == projectDocument) { throw new ArgumentNullException("projectDocument"); }

            // SoundPlayerの起動
            Cursor oldCursor = Cursor.Current;

            try
            {
                Cursor.Current = Cursors.WaitCursor;

                RunSoundPlayer(dvdRootPath,
                               port0,
                               port1,
                               port2,
                               port3,
                               port4,
                               port5,
                               projectDocument,
                               soundPlayerDirectoryPath);
            }
            finally
            {
                Cursor.Current = oldCursor;
            }
        }

        ///--------------------------------
        /// <summary>
        /// SoundPlayerの起動
        /// </summary>
        private static void RunSoundPlayer(string dvdRootPath,
                                           int port0,
                                           int port1,
                                           int port2,
                                           int port3,
                                           int port4,
                                           int port5,
                                           SoundProjectDocument projectDocument,
                                           string soundPlayerDirectoryPath)
        {
            if (null == dvdRootPath) { throw new ArgumentNullException("dvdRootPath"); }
            if (null == projectDocument) { throw new ArgumentNullException("projectDocument"); }

            if (Directory.Exists(soundPlayerDirectoryPath) == false)
            {
                return;
            }

            string winRun = Path.Combine(soundPlayerDirectoryPath, "WinRun.bat");

            /******************************************************************************
               コマンドライン引数の作成
            ******************************************************************************/
            string arguments = (" " + port0.ToString() +
                                " " + port1.ToString() +
                                " " + port2.ToString() +
                                " " + port3.ToString() +
                                " " + port4.ToString() +
                                " " + port5.ToString());

            /******************************************************************************
                ProcessStartInfoの作成
            ******************************************************************************/
            ProcessStartInfo startInfo = new ProcessStartInfo(winRun);
            startInfo.Arguments = arguments;
            startInfo.WorkingDirectory = soundPlayerDirectoryPath;

            /******************************************************************************
               プロセスの起動
            ******************************************************************************/
            Process soundPlayer = Process.Start(startInfo);

#if false   // HACK : cmd.exe / caferun からは即時に制御が返らないため、Wait しないようにします。
            soundPlayer.WaitForExit();
#endif
        }

        private static string ContentDirectory
        {
            get
            {
                return PathUtilityCommon.SoundPlayerContentsDirectory;
            }
        }
    }
}
