﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundMaker.Preview
{
    using System.Windows.Forms;

    /// <summary>
    /// プレビューモデル管理クラス
    /// </summary>
    public class PreviewManager
    {
        private static PreviewManager _instance;
        private static object _instanceLock = new object();

        private Control invokeControl = null;  // Invoke 用コントロール

        private PreviewManager()
        {
            this.PreviewPlayerManager = new PreviewPlayerManager();
            this.PreviewBankManager = new PreviewBankManager();
            this.EffectManager = new EffectManager();
        }

        public static PreviewManager Instance
        {
            get
            {
                lock (_instanceLock)
                {

                    if (null == _instance)
                    {
                        _instance = new PreviewManager();
                    }

                    return _instance;

                }
            }
        }

        public Control InvokeControl
        {
            get
            {
                if (null != this.invokeControl && !this.invokeControl.IsHandleCreated)
                {
                    return null;
                }

                return this.invokeControl;
            }
        }

        public PreviewPlayerManager PreviewPlayerManager { get; private set; }

        public PreviewBankManager PreviewBankManager { get; private set; }

        public EffectManager EffectManager { get; private set; }

        public void Initialize()
        {
            Initialize(null);
        }

        public void Initialize(Control invokeControl)
        {
            if (null == invokeControl)
            {
                this.invokeControl = new Control();
                this.invokeControl.CreateControl();
            }
            else
            {
                this.invokeControl = invokeControl;
            }

            this.PreviewPlayerManager.Initialize();
            this.PreviewBankManager.Initialize();
        }

        public void Uninitialize()
        {
            this.PreviewPlayerManager.Uninitialize();
            this.PreviewBankManager.Uninitialize();

            this.invokeControl = null;
        }

        public void Reset()
        {
            this.PreviewPlayerManager.ResetAll();
            this.PreviewBankManager.ResetAll();
        }
    }
}
