﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace Nintendo.Alto.Foundation.Communications
{
    using System;
    using System.Threading;

    /// <summary>
    /// Win 向けの HostIO 機能を提供します。
    /// </summary>
    public sealed class HostIOWin : IComEndPoint
    {
        //private static readonly Lazy<HostIOWin> instance = new Lazy<HostIOWin>(() => new HostIOWin());
        private static readonly HostIOWin instance = new HostIOWin();

        private readonly object connectLock = new object();

        private uint connectCount = 0;

        //-----------------------------------------------------------------

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        private HostIOWin()
        {
        }

        //-----------------------------------------------------------------

        /// <summary>
        /// インスタンスを取得します。
        /// </summary>
        public static IComEndPoint Instance
        {
            get { return HostIOWin.instance; }
        }

        /// <summary>
        /// 接続の有無を取得します。
        /// </summary>
        public bool IsConnected
        {
            get { return this.connectCount > 0; }
        }

        /// <summary>
        /// エンディアンを取得します。
        /// </summary>
        public bool IsLittleEndian
        {
            get { return true; }
        }

        //-----------------------------------------------------------------

        /// <summary>
        /// 接続を開始します。
        /// </summary>
        /// <param name="syncContext">同期コンテキストを指定します。</param>
        public void Connect(SynchronizationContext syncContext)
        {
            lock (this.connectLock)
            {
                // HostIOWinChannel.Open() に集約されているので、実装不要。
                this.connectCount++;
            }
        }

        /// <summary>
        /// 切断します。
        /// </summary>
        public void Disconnect()
        {
            lock (this.connectLock)
            {
                if (this.connectCount == 0)
                {
                    return;
                }

                // HostIOWinChannel.Close() に集約されているので、実装不要。
                this.connectCount--;
            }
        }

        public IComChannel OpenChannel(int port)
        {
            return HostIOWinChannel.Open(port, string.Empty);
        }

        IComChannel IComEndPoint.OpenChannel(object port)
        {
            //Ensure.Argument.True(port is int);
            return this.OpenChannel((int)port);
        }
    }
}
