﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using System.IO;
using System.Net;
using System.Net.Sockets;
using System.Threading;

namespace NintendoWare.Generic.Preview.Htcs.Sync
{
    using NintendoWare.SoundMaker.Framework.Preview.Communications;
    using NintendoWare.SoundMaker.Framework.Preview.Communications.Sync;
    using NintendoWare.SoundMaker.Framework.Preview.Communications.Tool;
    using NintendoWare.SoundMaker.Framework.Preview.Communications.Viewer;
    using NintendoWare.SoundMaker.Preview.Htcs;

    /// <summary>
    /// ビューア接続
    /// <para>
    /// ビューアからツールに送られるパケットを処理する接続です。
    /// </para>
    /// </summary>
    public class HtcsSyncConnection : HtcsConnection
    {
        static HtcsSyncConnection()
        {
            SyncPacket.Factories.Add(new SyncPacketFactory());
            SyncPacket.Factories.Add(new QueryInvalidItemPacketFactory());
        }

        // 読み込み間隔
        private const int Interval = 100;

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public HtcsSyncConnection()
        {
        }

        /// <summary>
        /// チャンネルの取得。
        /// </summary>
        public override uint Channel
        {
            get { return _baseChannel + 0x2; }
        }

        /// <summary>
        /// 接続
        /// </summary>
        public override bool Connect(IPEndPoint ipEndPoint, string hostName)
        {
            bool result = base.Connect(ipEndPoint, hostName);
            if (result)
            {
                SreSyncPacket.ResetTimeOut();
            }
            return result;
        }

        /// <summary>
        /// 接続（切断タイムアウトを指定して接続）
        /// </summary>
        public bool Connect(IPEndPoint ipEndPoint, string hostName, int timeout)
        {
            bool result = base.Connect(ipEndPoint, hostName);
            if (result)
            {
                SreSyncPacket.ResetTimeOut(timeout);
            }
            return result;
        }

        //---------------------------------------------------------------------
        /// <summary>
        /// メインループ。
        /// </summary>
        public override void MainLoop()
        {
            // ネットワークストリームのDataAvailableを利用した読み込み待ち
            if (!((NetworkStream)Reader.BaseStream).DataAvailable)
            {
                Thread.Sleep(Interval);

                if (SreSyncPacket.DoTimeOut == true)
                {
                    throw new TimeoutException("Sync connection time out");
                }

                return;
            }
            CommPacketHeader header = new SyncPacketHeader(Reader);
            Debug.Assert(!header.Error, "Header is null");

            SyncPacket packet = SyncPacket.Create(header);
            if (packet != null)
            {
                packet.Read(Reader, header);
                //ShowMessage( "  Sync ← " + packet );
                if (packet.Reply)
                {
                    CommPacketHeader replyHeader = packet.Write(Writer);
                    Writer.Flush();
                    //ShowMessage( "       → " + replyHeader );
                }
            }
        }
    }
}
