﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundMaker.Preview.Configurations
{
    using System;
    using NintendoWare.SoundMaker.Configurations.Schemas;
    using NW4R.ProtocolSound;

    public static class EffectIDConverter
    {
        public static EffectID Convert(XmlEffect xmlEffect)
        {
            return new EffectID(ConvertEffectBusType(xmlEffect.BusType),
                                 (uint)xmlEffect.Index);
        }

        public static ToolSoundAuxBusType ConvertEffectBusType(XmlEffectBusType busType)
        {
            switch (busType)
            {
                case XmlEffectBusType.AuxA:
                    return ToolSoundAuxBusType.AuxBusType_AuxA;

                case XmlEffectBusType.AuxB:
                    return ToolSoundAuxBusType.AuxBusType_AuxB;

                case XmlEffectBusType.AuxC:
                    return ToolSoundAuxBusType.AuxBusType_AuxC;
            }

            throw new ApplicationException("invalid effect bus type.");
        }

        public static XmlEffectBusType ConvertEffectBusType(ToolSoundAuxBusType busType)
        {
            switch (busType)
            {
                case ToolSoundAuxBusType.AuxBusType_AuxA:
                    return XmlEffectBusType.AuxA;

                case ToolSoundAuxBusType.AuxBusType_AuxB:
                    return XmlEffectBusType.AuxB;

                case ToolSoundAuxBusType.AuxBusType_AuxC:
                    return XmlEffectBusType.AuxC;
            }

            throw new ApplicationException("invalid effect bus type.");
        }
    }
}
