﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundMaker.Preview.Configurations
{
    using NintendoWare.SoundMaker.Configurations.Schemas;

    public class DelayConverter : EffectConverter<XmlDelay, DelayParameter>
    {
        protected override void ApplyParameters(XmlDelay xmlEffect, DelayParameter effectParameter)
        {
            effectParameter.MaxDelayTime = xmlEffect.MaxDelayTime;
            effectParameter.DelayTime = xmlEffect.DelayTime;
            effectParameter.Feedback = xmlEffect.Feedback;
            effectParameter.OutGain = xmlEffect.OutGain;
            effectParameter.LPF = xmlEffect.LPF;
        }

        protected override void ExtractParameters(DelayParameter effectParameter, XmlDelay xmlEffect)
        {
            xmlEffect.MaxDelayTime = effectParameter.MaxDelayTime;
            xmlEffect.DelayTime = effectParameter.DelayTime;
            xmlEffect.Feedback = effectParameter.Feedback;
            xmlEffect.OutGain = effectParameter.OutGain;
            xmlEffect.LPF = effectParameter.LPF;
        }
    }
}
