﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Net;
using System.Runtime.InteropServices;

/*

    ==========================================================================
    ※このプロトコルヘッダは、
    $(NW4R_ROOT)/ToolUtil/ProtocolUtil/Protocol/ProtocolSound/ProtocolSound.xml
    から自動生成されて作られたものです。
    プロトコルを編集する際には、.h及び.csファイルを直接編集するのではなく
    ProtocolSound.xmlファイルを編集し再コンバートする必要があります。
    ==========================================================================

    Viewer - SoundMaker通信プロトコル

    通信メッセージの種類
        ビューアメッセージ  ビューアからエディタに送るメッセージ
        エディタメッセージ  エディタからビューアに送るメッセージ
        エラーメッセージ    エラーが起こった際に送るメッセージ

    通信の際には必ずMessageHeaderを送信し、その次にMessageDataを送信します。
    MessageHeaderは2byteのMessageTypeと2byteのMessageSizeからなります。

    +---------------------------+--------------------+
    |      MessageHeader        |    MessageData     |
    +-------------+-------------+                    |
    | MessageType | MessageSize | (MessageSize byte) |
    | (2byte)     | (2byte)     |                    |
    +-------------+-------------+--------------------+

    MessageTypeは1bitのErrorFlag、1bitのReplyFlag、6bitのCategory
    8bitのCommandからなります。

    15             8 7             0
    +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
    |E|R| Category  |    Command    |
    +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
    Errorがtrueの時にはReplyは必ずfalseになります。
 */
namespace NW4F.ProtocolSound
{
    using NW4R.ProtocolSound;
    using NintendoWare.SoundMaker.Framework.Preview.Communications;

    //-----------------------------------------------------------------------
    /** <summary>プレビュープレイヤーパラメータ</summary> */
    public class ToolSoundPreviewPlayerParameter
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + (1 * 16) + (4 * 16) +
        4 + 4 + 4 +
        4 + 4 + 4 + 4 +
        4 + 4 + 4 + 4;


        /** <summary> 4B: 対象プレビュープレイヤーのインデックス</summary> */
        public uint previewPlayerIndex;
        /** <summary> 4B: 音量</summary> */
        public float volume;
        /** <summary> 4B: ピッチ</summary> */
        public float pitch;
        /** <summary> 4B: パン</summary> */
        public float pan;
        /** <summary> 4B: サラウンドパン</summary> */
        public float surroundPan;
        /** <summary> 4B: パン(DRC)</summary> */
        public float drcPan;
        /** <summary> 4B: LPF周波数</summary> */
        public float lpfFrequency;
        /** <summary> 4B: BiquadType</summary> */
        public ToolSoundBiquadType biquadType;
        /** <summary> 4B: BiquadValue</summary> */
        public float biquadValue;
        /** <summary> 4B: 再生開始位置 [ms]</summary> */
        public uint startOffsetTime;
        /** <summary> 4B: メイン 出力スイッチ</summary> */
        public int mainOutEnabled;
        /** <summary> 4B: DRC 出力スイッチ</summary> */
        public int drcOutEnabled;
        /** <summary> 4B: Wiiリモコン1 出力スイッチ</summary> */
        public int remote0OutEnabled;
        /** <summary> 4B: Wiiリモコン2 出力スイッチ</summary> */
        public int remote1OutEnabled;
        /** <summary> 4B: Wiiリモコン3 出力スイッチ</summary> */
        public int remote2OutEnabled;
        /** <summary> 4B: Wiiリモコン4 出力スイッチ</summary> */
        public int remote3OutEnabled;
        /** <summary> 4B: メイン 出力</summary> */
        public float mainOutVolume;
        /** <summary> 4B: DRC 出力</summary> */
        public float drcOutVolume;
        /** <summary> 4B: Wiiリモコン1 出力</summary> */
        public float remote0OutVolume;
        /** <summary> 4B: Wiiリモコン2 出力</summary> */
        public float remote1OutVolume;
        /** <summary> 4B: Wiiリモコン3 出力</summary> */
        public float remote2OutVolume;
        /** <summary> 4B: Wiiリモコン4 出力</summary> */
        public float remote3OutVolume;
        /** <summary> 4B: メイン センド</summary> */
        public float mainSend;
        /** <summary> 4B: エフェクト Aux A センド</summary> */
        public float effectAuxASend;
        /** <summary> 4B: エフェクト Aux B センド</summary> */
        public float effectAuxBSend;
        /** <summary> 4B: エフェクト Aux C センド</summary> */
        public float effectAuxCSend;
        /** <summary> 4B: フェードインフレーム</summary> */
        public int fadeInFrames;
        /** <summary> 4B: フェードアウトフレーム</summary> */
        public int fadeOutFrames;
        /** <summary> 4B: ポーズフェードフレーム</summary> */
        public int pauseFadeFrames;
        /** <summary> 1B*16=16B: トラックミュート</summary> */
        public bool[] tracksMute = new bool[16];
        /** <summary> 4B*16=64B: トラックボリューム</summary> */
        public float[] tracksVolume = new float[16];

        /** <summary> 4B: パン(メイン)</summary> */
        public float mainPan;
        /** <summary> 4B: サラウンドパン(メイン)</summary> */
        public float mainSurroundPan;
        /** <summary> 4B: サラウンドパン(DRC)</summary> */
        public float drcSurroundPan;

        /** <summary> 4B: メイン センド(メイン)</summary> */
        public float mainMainSend;
        /** <summary> 4B: エフェクト Aux A センド(メイン)</summary> */
        public float mainEffectAuxASend;
        /** <summary> 4B: エフェクト Aux B センド(メイン)</summary> */
        public float mainEffectAuxBSend;
        /** <summary> 4B: エフェクト Aux C センド(メイン)</summary> */
        public float mainEffectAuxCSend;

        /** <summary> 4B: メイン センド(DRC)</summary> */
        public float drcMainSend;
        /** <summary> 4B: エフェクト Aux A センド(DRC)</summary> */
        public float drcEffectAuxASend;
        /** <summary> 4B: エフェクト Aux B センド(DRC)</summary> */
        public float drcEffectAuxBSend;
        /** <summary> 4B: エフェクト Aux C センド(DRC)</summary> */
        public float drcEffectAuxCSend;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            previewPlayerIndex = reader.ReadUInt32();
            volume = reader.ReadSingle();
            pitch = reader.ReadSingle();
            pan = reader.ReadSingle();
            surroundPan = reader.ReadSingle();
            drcPan = reader.ReadSingle();
            lpfFrequency = reader.ReadSingle();
            biquadType = (ToolSoundBiquadType)reader.ReadInt32();
            biquadValue = reader.ReadSingle();
            startOffsetTime = reader.ReadUInt32();
            mainOutEnabled = reader.ReadInt32();
            drcOutEnabled = reader.ReadInt32();
            remote0OutEnabled = reader.ReadInt32();
            remote1OutEnabled = reader.ReadInt32();
            remote2OutEnabled = reader.ReadInt32();
            remote3OutEnabled = reader.ReadInt32();
            mainOutVolume = reader.ReadSingle();
            drcOutVolume = reader.ReadSingle();
            remote0OutVolume = reader.ReadSingle();
            remote1OutVolume = reader.ReadSingle();
            remote2OutVolume = reader.ReadSingle();
            remote3OutVolume = reader.ReadSingle();
            mainSend = reader.ReadSingle();
            effectAuxASend = reader.ReadSingle();
            effectAuxBSend = reader.ReadSingle();
            effectAuxCSend = reader.ReadSingle();
            fadeInFrames = reader.ReadInt32();
            fadeOutFrames = reader.ReadInt32();
            pauseFadeFrames = reader.ReadInt32();
            for (int i = 0; i < 16; i++)
            {
                tracksMute[i] = reader.ReadBoolean();
            }
            for (int i = 0; i < 16; i++)
            {
                tracksVolume[i] = reader.ReadSingle();
            }

            mainPan = reader.ReadSingle();
            mainSurroundPan = reader.ReadSingle();
            drcSurroundPan = reader.ReadSingle();

            mainMainSend = reader.ReadSingle();
            mainEffectAuxASend = reader.ReadSingle();
            mainEffectAuxBSend = reader.ReadSingle();
            mainEffectAuxCSend = reader.ReadSingle();

            drcMainSend = reader.ReadSingle();
            drcEffectAuxASend = reader.ReadSingle();
            drcEffectAuxBSend = reader.ReadSingle();
            drcEffectAuxCSend = reader.ReadSingle();
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write(previewPlayerIndex);
            writer.Write(volume);
            writer.Write(pitch);
            writer.Write(pan);
            writer.Write(surroundPan);
            writer.Write(drcPan);
            writer.Write(lpfFrequency);
            writer.Write((int)biquadType);
            writer.Write(biquadValue);
            writer.Write(startOffsetTime);
            writer.Write(mainOutEnabled);
            writer.Write(drcOutEnabled);
            writer.Write(remote0OutEnabled);
            writer.Write(remote1OutEnabled);
            writer.Write(remote2OutEnabled);
            writer.Write(remote3OutEnabled);
            writer.Write(mainOutVolume);
            writer.Write(drcOutVolume);
            writer.Write(remote0OutVolume);
            writer.Write(remote1OutVolume);
            writer.Write(remote2OutVolume);
            writer.Write(remote3OutVolume);
            writer.Write(mainSend);
            writer.Write(effectAuxASend);
            writer.Write(effectAuxBSend);
            writer.Write(effectAuxCSend);
            writer.Write(fadeInFrames);
            writer.Write(fadeOutFrames);
            writer.Write(pauseFadeFrames);
            for (int i = 0; i < 16; i++)
            {
                writer.Write(tracksMute[i]);
            }
            for (int i = 0; i < 16; i++)
            {
                writer.Write(tracksVolume[i]);
            }

            writer.Write(mainPan);
            writer.Write(mainSurroundPan);
            writer.Write(drcSurroundPan);

            writer.Write(mainMainSend);
            writer.Write(mainEffectAuxASend);
            writer.Write(mainEffectAuxBSend);
            writer.Write(mainEffectAuxCSend);

            writer.Write(drcMainSend);
            writer.Write(drcEffectAuxASend);
            writer.Write(drcEffectAuxBSend);
            writer.Write(drcEffectAuxCSend);
        }
    }

    /// <summary>
    ///
    /// </summary>
    public class ToolSoundOutputModeParameters
    {
        /// <summary>構造体にした場合のサイズ</summary>
        public const int StructSize =
            0 + 4 + 4;
        /** <summary> 4B: Main出力モード</summary> */
        public ToolSoundOutputMode mainOutputMode;
        /** <summary> 4B: DRC出力モード</summary> */
        public ToolSoundOutputMode drcOutputMode;

        /// <summary>読み込みメソッド</summary>
        public virtual void Read(ProtocolSoundReader reader)
        {
            mainOutputMode = (ToolSoundOutputMode)reader.ReadInt32();
            drcOutputMode = (ToolSoundOutputMode)reader.ReadInt32();
        }

        /// <summary>書き出しメソッド</summary>
        public virtual void Write(ProtocolSoundWriter writer)
        {
            writer.Write((int)mainOutputMode);
            writer.Write((int)drcOutputMode);
        }
    }
}
