﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Configuration;
using System.IO;
using System.Reflection;

namespace NintendoWare.SoundMaker
{
    using NintendoWare.SoundMakerPlugin;

    /// <summary>
    ///
    /// </summary>
    public class PathUtilityCommon
    {
        public static string HelpURL
        {
            get
            {
                return new Uri(GetExpandedAppSetting("HelpURL")).ToString();
            }
        }

        public static string TroubleshootingHelpURL
        {
            get
            {
                return new Uri(GetExpandedAppSetting("TroubleshootingHelpURL")).ToString();
            }
        }

        public static string OptionHelpURL
        {
            get
            {
                return new Uri(GetExpandedAppSetting("OptionHelpURL")).ToString();
            }
        }

        public static string ProjectSettingsHelpURL
        {
            get
            {
                return new Uri(GetExpandedAppSetting("ProjectSettingsHelpURL")).ToString();
            }
        }

        public static string AtkPlayerHelpURL
        {
            get
            {
                return new Uri(GetExpandedAppSetting("AtkPlayerHelpURL")).ToString();
            }
        }

        public static string PCAtkPlayerFilePath
        {
            get
            {
                return GetExpandedAppSetting("PCAtkPlayerFilePath");
            }
        }

        public static string SoundPlayerHelpFilePath
        {
            get
            {
                return GetExpandedAppSetting("SoundPlayerHelpFilePath");
            }
        }

        public static string SoundPlayerDirectory
        {
            get
            {
                return GetExpandedAppSetting("SoundPlayerDirectory");
            }
        }

        public static string SoundPlayerContentsDirectory
        {
            get
            {
                return ExpandMacro(CurrentSoundMakerPlugin.GetExpandedAppSetting("SoundPlayerContentsDirectory"));
            }
        }

        public static string SoundPlayerTempDirectory
        {
            get
            {
                return ExpandMacro(CurrentSoundMakerPlugin.GetExpandedAppSetting("SoundPlayerTempDirectory"));
            }
        }

        public static string SequenceSoundConverterFilePath
        {
            get
            {
                return GetExpandedAppSetting("SequenceSoundConverterFilePath");
            }
        }

        public static string SmfConverterFilePath
        {
            get
            {
                return GetExpandedAppSetting("SmfConverterFilePath");
            }
        }

        private static string GetExpandedAppSetting(string key)
        {
            return ExpandMacro(System.Configuration.ConfigurationManager.AppSettings[key]);
        }

        private static string ExpandMacro(string value)
        {
            string executingDirectory = Path.GetFullPath(Path.GetDirectoryName(Assembly.GetEntryAssembly().Location));

            return value.Replace("$(SoundMakerDirectory)", executingDirectory);
        }

        private static ISoundMakerPlugin CurrentSoundMakerPlugin
        {
            get
            {
                return SoundMakerPluginManager.Instance.CurrentSoundMakerPlugin;
            }
        }
    }
}
