﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Projects
{
    /// <summary>
    /// <see cref="ProjectParameterNames"/> への追加のプロジェクトパラメータ名定義です。
    /// </summary>
    public static class ProjectParameterNamesCommon
    {
        private const string Sep = ProjectParameterNames.ParameterKeySeparator;

        public static class Sends
        {
            public const string AuxCSend = nameof(Sends) + Sep + nameof(AuxCSend);
        }

        public static class StreamSoundTrack
        {
            public static class Sends
            {
                public const string AuxCSend = "TrackSends" + Sep + nameof(ProjectParameterNamesCommon.Sends.AuxCSend);
            }
        }

        public const string RemoteFilter = "RemoteFilter";
    }
}
