﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Projects
{
    using NintendoWare.SoundFoundation.Documents;

    /// <summary>
    /// バンクドキュメントを生成します。
    /// </summary>
    public class BankDocumentFactoryCafe : BankDocumentFactory
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public BankDocumentFactoryCafe()
            : base(Platforms.Cafe.BankDocument)
        {
        }

        /// <summary>
        /// ドキュメントを生成します。
        /// </summary>
        /// <returns>生成されたドキュメント。</returns>
        public override Document CreateDocument()
        {
            return new BankDocument(Platforms.Any.BankDocument);
        }
    }
}
