﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary
{
    using System;
    using System.Runtime.InteropServices;
    using Binarization;

    [StructLayout(LayoutKind.Sequential)]
    [DomElement(Tags = new string[] { "Element" })]
    [DomElementType(Value = (UInt16)ElementType.Parameter_Envelope)]
    internal class ParameterEnvelope
    {
        private object data;

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        [DomObjectReference(
            OriginTag = "Element", HasType = true, HasOffset = true)]
        public object DataReference
        {
            get { return this.data; }
        }

        public object Data
        {
            get { return this.data; }
            set
            {
                if (value is ParameterAdshrEnvelope)
                {
                    this.data = value;
                    return;
                }

                throw new Exception("internal error : invalid value type.");
            }
        }
    }
}
