﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary
{
    using System;
    using System.Runtime.InteropServices;
    using Binarization;
    using ToolDevelopmentKit;

    [StructLayout(LayoutKind.Sequential)]
    internal abstract class ParameterArray
    {
        private UInt32 itemFlag;
        private IParameterValue[] items = new IParameterValue[32];

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        public UInt32 ItemFlags
        {
            get
            {
                UInt32 flags = 0;
                UInt32 trueBit = 1;

                foreach (IParameterValue value in items)
                {
                    if (value != null)
                    {
                        flags |= trueBit;
                    }

                    trueBit <<= 1;
                }

                return flags;
            }
        }

        [EnumeratedField(IsOptional = true)]
        public IParameterValue[] Items
        {
            get { return this.items; }
        }

        //-----------------------------------------------------------------
        // パラメータの操作
        //-----------------------------------------------------------------

        protected TParameter GetValue<TParameter>(int index)
            where TParameter : class, IParameterValue
        {
            return this.Items[index] as TParameter;
        }

        protected void SetValue(int index, IParameterValue parameter)
        {
            this.Items[index] = parameter;
        }
    }
}
