﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary
{
    using System;
    using System.Collections.Generic;
    using System.Runtime.InteropServices;
    using NintendoWare.SoundFoundation.Binarization;
    using NintendoWare.SoundFoundation.Core.Collections;

    [StructLayout(LayoutKind.Sequential)]
    [DomElement(Tags = new string[] { "Element" })]
    [DomElementType(Value = (UInt16)ElementType.SoundArchiveFile_PatriciaTree)]
    internal class PatriciaTreeBinary
    {
        public PatriciaTreeBinary()
        {
            this.Nodes = new List<PatriciaTreeNodeBinary>();
        }

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        public UInt32 RootIndex { get; set; }

        public UInt32 NodeCount
        {
            get { return (UInt32)this.Nodes.Count; }
        }

        public IList<PatriciaTreeNodeBinary> Nodes { get; set; }
    }
}
