﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary
{
    using System;
    using System.Collections.Generic;
    using System.IO;
    using System.Runtime.InteropServices;
    using Binarization;
    using Projects;
    using ToolDevelopmentKit;

    [StructLayout(LayoutKind.Sequential)]
    [DomElement(Tags = new string[] { "Element" })]
    [DomElementType(Value = (UInt16)ElementType.Codec_DspAdpcmInfo)]
    internal class DspAdpcmInfo
    {
        private UInt16[] coef = new UInt16[16];

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        public UInt16[] Coef
        {
            get { return this.coef; }
            set
            {
                Ensure.Argument.NotNull(value);
                Ensure.Argument.True(value.Length == 16);
                this.coef = value;
            }
        }

        public UInt16 PredScale { get; set; }

        public UInt16 Yn1 { get; set; }

        public UInt16 Yn2 { get; set; }

        public UInt16 LoopPredScale { get; set; }

        public UInt16 LoopYn1 { get; set; }

        public UInt16 LoopYn2 { get; set; }

        public UInt16 Padding { get; set; }
    }
}
