﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary
{
    using System;
    using System.Collections.Generic;
    using System.Runtime.InteropServices;
    using Binarization;

    [StructLayout(LayoutKind.Sequential)]
    internal class SoundCommonFileHeader : CommonFileHeader
    {
        //-----------------------------------------------------------------
        // データ構造のオーバーライド
        //-----------------------------------------------------------------

        public override UInt16 BlockCount
        {
            get { return (UInt16)this.BlockReferencesWithSize.Count; }
            set { }
        }

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        [DomObjectReference(
            OriginTag = "Element",
            HasType = true, HasOffset = true, HasSize = true,
            SizeType = SizeType.OffsetToNext)]
        public IList<CommonBlock> BlockReferencesWithSize { get; set; }
    }
}
