﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary
{
    using System;
    using System.Runtime.InteropServices;
    using Binarization;
    using ToolDevelopmentKit;

    [StructLayout(LayoutKind.Sequential)]
    [DomElement(Tags = new string[] { "Element" })]
    [DomElementType(Value = (UInt16)ElementType.General_String)]
    internal class NullTerminateString
    {
        private string text = string.Empty;

        public NullTerminateString()
        {
        }

        public NullTerminateString(string text)
        {
            this.Text = text;
        }

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        public string Text
        {
            get { return this.text; }
            set
            {
                Ensure.Argument.NotNull(value);
                this.text = value;
            }
        }

        public Byte TerminationChar
        {
            get { return 0x00; }
        }
    }
}
