﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary
{
    using System;
    using System.IO;
    using System.Runtime.InteropServices;
    using NintendoWare.SoundFoundation.Binarization;
    using NintendoWare.ToolDevelopmentKit;

    [StructLayout(LayoutKind.Sequential)]
    [DomElement(Tags = new string[] { "Element" })]
    [DomElementType(Value = (UInt16)ElementType.General_ByteStream)]
    public class FileObject : IFileObject
    {
        private string filePath;

        //-----------------------------------------------------------------

        public FileObject(string filePath)
        {
            Ensure.Argument.NotNull(filePath);
            Ensure.Argument.StringNotEmpty(filePath);

            this.filePath = filePath;
        }

        //-----------------------------------------------------------------

        /// <summary>
        /// 出力パスを取得します。
        /// </summary>
        [DomIgnoreField]
        public string Path
        {
            get { return this.filePath; }
        }

        //-----------------------------------------------------------------

        /// <summary>
        /// 指定したキーに関連する読み込み用の出力ストリームを開きます。
        /// </summary>
        /// <returns>入力ストリームを返します。</returns>
        public Stream OpenRead()
        {
            return File.Open(this.filePath, FileMode.Open, FileAccess.Read, FileShare.Read);
        }
    }
}
