﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary
{
    using System;
    using System.Collections.Generic;
    using System.Runtime.InteropServices;
    using Binarization;

    [StructLayout(LayoutKind.Sequential)]
    internal class CommonBlockHeader
    {
        private string signature = "    ";

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        public string Signature
        {
            get { return this.signature; }
            set
            {
                if (null == value) { throw new ArgumentNullException("value"); }
                if (4 != value.Length) { throw new ArgumentOutOfRangeException("value"); }
                this.signature = value;
            }
        }

        [DomObjectReference(HasSize = true, SizeType = SizeType.OffsetToNext)]
        public CommonBlock Block { get; set; }
    }
}
