﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.SoundArchiveXmlElements
{
    using System;
    using System.Collections.Generic;
    using System.Globalization;
    using System.Xml.Serialization;
    using NintendoWare.ToolDevelopmentKit;

    /// <summary>
    /// 要素マップアイテムを格納します。
    /// </summary>
    [Serializable]
    public class FileElementMapItemXml : ElementMapItemXml
    {
        public FileElementMapItemXml()
        {
            this.FileID = BinaryItemID.InvalidValue;
        }

        /// <summary>
        /// 16進数表記の FileID（テキスト）を取得または設定します。
        /// </summary>
        [XmlAttribute("FileID")]
        public string FileIDText { get; set; }

        [XmlIgnore]
        public bool FileIDTextSpecified
        {
            get { return this.FileID != BinaryItemID.InvalidValue; }
        }

        /// <summary>
        /// 16進数表記の FileID（数値）を取得または設定します。
        /// </summary>
        [XmlIgnore]
        internal UInt32 FileID
        {
            get
            {
                if (this.FileIDText == null || this.FileIDText.Length == 0)
                {
                    return BinaryItemID.InvalidValue;
                }

                return UInt32.Parse(this.FileIDText, NumberStyles.HexNumber);
            }
            set
            {
                Ensure.Argument.NotNull(value);
                this.FileIDText = value.ToString("X8");
            }
        }
    }
}
