﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.SoundArchiveElements
{
    using System.Runtime.InteropServices;
    using Binarization;

    [StructLayout(LayoutKind.Sequential)]
    internal class WaveArchiveParameterArray : ParameterArray
    {
        private const int StringIDIndex = 0;
        private const int WaveCountIndex = 1;

        //-----------------------------------------------------------------
        // データ構造（複合パラメータ）
        //-----------------------------------------------------------------

        // なし

        //-----------------------------------------------------------------
        // パラメータの操作
        //-----------------------------------------------------------------

        [DomIgnoreField]
        public ParameterUInt32 StringID
        {
            get { return GetValue<ParameterUInt32>(StringIDIndex); }
            set { SetValue(StringIDIndex, value); }
        }

        [DomIgnoreField]
        public ParameterUInt32 WaveCount
        {
            get { return GetValue<ParameterUInt32>(WaveCountIndex); }
            set { SetValue(WaveCountIndex, value); }
        }
    }
}
