﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.SoundArchiveElements
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Runtime.InteropServices;
    using Binarization;

    [StructLayout(LayoutKind.Sequential)]
    [DomElement(Tags = new string[] { "Element" })]
    [DomElementType(Value = (UInt16)ElementType.SoundArchiveFile_SoundArchivePlayerInfo)]
    internal class SoundArchivePlayerInfo
    {
        public static class DevelopFlagBits
        {
            public const int EnableWaveSound2Bit = 0;
        }

        private UInt16 sequenceSoundMax = 0;
        private UInt16 sequenceTrackMax = 0;
        private UInt16 streamSoundMax = 0;
        private UInt16 streamTrackMax = 0;
        private UInt16 streamChannelMax = 0;
        private UInt16 waveSoundMax = 0;
        private UInt16 waveTrackMax = 0;
        private Byte streamBufferTimes = 1;
        private SoundArchivePlayerParameterArray parameters = new SoundArchivePlayerParameterArray();

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        public UInt16 SequenceSoundMax
        {
            get { return this.sequenceSoundMax; }
            set { this.sequenceSoundMax = value; }
        }

        public UInt16 SequenceTrackMax
        {
            get { return this.sequenceTrackMax; }
            set { this.sequenceTrackMax = value; }
        }

        public UInt16 StreamSoundMax
        {
            get { return this.streamSoundMax; }
            set { this.streamSoundMax = value; }
        }

        public UInt16 StreamTrackMax
        {
            get { return this.streamTrackMax; }
            set { this.streamTrackMax = value; }
        }

        public UInt16 StreamChannelMax
        {
            get { return this.streamChannelMax; }
            set { this.streamChannelMax = value; }
        }

        public UInt16 WaveSoundMax
        {
            get { return this.waveSoundMax; }
            set { this.waveSoundMax = value; }
        }

        public UInt16 WaveTrackMax
        {
            get { return this.waveTrackMax; }
            set { this.waveTrackMax = value; }
        }

        public Byte StreamBufferTimes
        {
            get { return this.streamBufferTimes; }
            set { this.streamBufferTimes = value; }
        }

        public Byte DevelopFlags { get; set; }

        public SoundArchivePlayerParameterArray Parameters
        {
            get { return this.parameters; }
        }
    }
}
