﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.SoundArchiveXmlElements;

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary
{
    using System;
    using System.Collections.Generic;
    using System.Xml.Serialization;
    using NintendoWareBinary.SoundArchiveXmlElements;

    /// <summary>
    /// サウンドアーカイブバイナリの情報を格納します。
    /// </summary>
    [Serializable]
    [XmlRoot(
        "SoundArchiveBinary",
        Namespace = XmlNamespaces.Base,
        IsNullable = false)]
    public class SoundArchiveBinaryXml
    {
        [XmlAttribute("Name")]
        public string Name { get; set; }

        [XmlArray("Sounds")]
        [XmlArrayItem("StreamSound", typeof(StreamSoundXml))]
        [XmlArrayItem("WaveSound", typeof(WaveSoundXml))]
        [XmlArrayItem("SequenceSound", typeof(SequenceSoundXml))]
        public List<SoundXml> Sounds { get; set; }

        [XmlArray("SoundGroups")]
        [XmlArrayItem("WaveSoundGroup", typeof(WaveSoundGroupXml))]
        [XmlArrayItem("SequenceSoundGroup", typeof(SequenceSoundGroupXml))]
        public List<SoundGroupXml> SoundGroups { get; set; }

        [XmlArray("SoundSetBanks")]
        [XmlArrayItem("SoundSetBank", typeof(SoundSetBankXml))]
        public List<SoundSetBankXml> SoundSetBanks { get; set; }

        [XmlArray("Players")]
        [XmlArrayItem("Player", typeof(PlayerXml))]
        public List<PlayerXml> Players { get; set; }

        [XmlArray("WaveArchives")]
        [XmlArrayItem("WaveArchive", typeof(WaveArchiveXml))]
        public List<WaveArchiveXml> WaveArchives { get; set; }

        [XmlArray("Groups")]
        [XmlArrayItem("Group", typeof(GroupXml))]
        public List<GroupXml> Groups { get; set; }

        [XmlArray("Files")]
        [XmlArrayItem("InternalFile", typeof(InternalFileXml))]
        [XmlArrayItem("ExternalFile", typeof(ExternalFileXml))]
        public List<FileXml> Files { get; set; }

        [XmlArray("WaveFiles")]
        [XmlArrayItem("WaveFile", typeof(WaveFileXml))]
        public List<WaveFileXml> WaveFiles { get; set; }

        [XmlElement("ElementMap")]
        public ElementMapXml ElementMap { get; set; }

        [XmlAttribute]
        public bool IsAddonSoundArchive { get; set; }
    }
}
