﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.GroupElements
{
    using System;
    using System.IO;
    using System.Runtime.InteropServices;
    using Binarization;

    [StructLayout(LayoutKind.Sequential)]
    [DomElement(Tags = new string[] { "Element" })]
    [DomElementType(Value = (UInt16)ElementType.GroupFile_GroupItemInfo)]
    internal class GroupItemInfo
    {
        public GroupItemInfo()
        {
            this.FileID = UInt32.MaxValue;
        }

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        public UInt32 FileID { get; set; }

        [DomObjectReference(
            OriginTag = "BinaryRoot", OriginPath = "Blocks/FILE/Body",
            HasType = true, HasOffset = true, HasSize = true)]
        public object File { get; set; }
    }
}
