﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary
{
    using System.Runtime.InteropServices;
    using Binarization;
    using GroupElements;
    using ToolDevelopmentKit;

    [StructLayout(LayoutKind.Sequential)]
    internal class GroupBinary : SoundCommonFileRoot
    {
        private InfoBlock infoBlock = new InfoBlock();
        private FileBlock fileBlock = new FileBlock();
        private InfoExBlock infoExBlock = new InfoExBlock();

        public GroupBinary(
            string signature,
            byte majorVersion, byte minorVersion, byte microVersion, byte binaryBugFixVersion)
            : base(signature, majorVersion, minorVersion, microVersion, binaryBugFixVersion)
        {
            UpdateBlocks();
        }

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        // 基底クラス CommonFileRoot のデータ構造と同じです。

        //-----------------------------------------------------------------
        // パラメータの操作
        //-----------------------------------------------------------------

        [DomIgnoreField]
        public CommonBlock<InfoBlockBody> InfoBlock
        {
            get { return this.infoBlock; }
        }

        [DomIgnoreField]
        public CommonBlock<FileBlockBody> FileBlock
        {
            get { return this.fileBlock; }
        }

        [DomIgnoreField]
        public CommonBlock<InfoExBlockBody> InfoExBlock
        {
            get { return this.infoExBlock; }
        }

        private void UpdateBlocks()
        {
            this.Blocks.Clear();

            this.Blocks.Add(this.infoBlock);
            this.Blocks.Add(this.fileBlock);
            this.Blocks.Add(this.infoExBlock);
        }
    }
}
