﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.BankElements
{
    using System;
    using System.Runtime.InteropServices;
    using Binarization;

    [StructLayout(LayoutKind.Sequential)]
    internal class InstrumentNoteInfoParameterArray : ParameterArray
    {
        private const int KeyIndex = 0;
        private const int VolumeIndex = 1;
        private const int PanIndex = 2;
        private const int PitchIndex = 3;
        private const int InstrumentNoteParamIndex = 4;
        private const int SendsIndex = 8;       // 欠番（予約）
        private const int EnvelopeIndex = 9;
        private const int RandomizerIndex = 10; // 未実装
        private const int LfoIndex = 11;        // 未実装

        //-----------------------------------------------------------------
        // データ構造（複合パラメータ）
        //-----------------------------------------------------------------

        [DomField(IsOptional = true)]
        public ParameterEnvelope Envelope
        {
            get
            {
                ParameterReference<ParameterEnvelope> value =
                    GetValue<ParameterReference<ParameterEnvelope>>(EnvelopeIndex);
                if (value == null) { return null; }
                return value.Value;
            }
            set
            {
                if (value == null)
                {
                    SetValue(EnvelopeIndex, null);
                    return;
                }

                SetValue(EnvelopeIndex, new ParameterReference<ParameterEnvelope>(value));
            }
        }

        //-----------------------------------------------------------------
        // パラメータの操作
        //-----------------------------------------------------------------

        [DomIgnoreField]
        public ParameterKey Key
        {
            get { return GetValue<ParameterKey>(KeyIndex); }
            set { SetValue(KeyIndex, value); }
        }

        [DomIgnoreField]
        public ParameterVolume Volume
        {
            get { return GetValue<ParameterVolume>(VolumeIndex); }
            set { SetValue(VolumeIndex, value); }
        }

        [DomIgnoreField]
        public ParameterPan Pan
        {
            get { return GetValue<ParameterPan>(PanIndex); }
            set { SetValue(PanIndex, value); }
        }

        [DomIgnoreField]
        public ParameterSingle Pitch
        {
            get { return GetValue<ParameterSingle>(PitchIndex); }
            set { SetValue(PitchIndex, value); }
        }

        [DomIgnoreField]
        public ParameterInstrumentNoteParam InstrumentNoteParam
        {
            get { return GetValue<ParameterInstrumentNoteParam>(InstrumentNoteParamIndex); }
            set { SetValue(InstrumentNoteParamIndex, value); }
        }
    }
}
