﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary.BankElements
{
    using System;
    using System.Collections.Generic;
    using System.Runtime.InteropServices;
    using NintendoWare.SoundFoundation.Binarization;
    using NintendoWare.SoundFoundation.Projects;
    using NintendoWare.ToolDevelopmentKit;

    [StructLayout(LayoutKind.Sequential)]
    internal class InstrumentSet : InstrumentItemSet<InstrumentInfo>
    {
        //-----------------------------------------------------------------
        // パラメータの操作
        //-----------------------------------------------------------------

        protected override object CreateTable(IList<IInstrumentItem> items)
        {
            Assertion.Argument.NotNull(items);

            return new ReferenceTable<IInstrumentItem>()
            {
                Items = items,
            };
        }

        protected override IList<IInstrumentItem> CreateItems()
        {
            Dictionary<int, InstrumentInfo> instruments = new Dictionary<int, InstrumentInfo>();

            foreach (InstrumentInfo item in this.Items)
            {
                if (instruments.ContainsKey(item.ProgramNo))
                {
                    throw new Exception(
                        string.Format("internal error : program no {0} already exists.", item.ProgramNo));
                }

                instruments.Add(item.ProgramNo, item);
            }

            List<IInstrumentItem> items = new List<IInstrumentItem>();
            int hitCount = 0;

            if (instruments.Count > 0)
            {
                for (int programNo = 0; programNo < Instrument.ProgramNoMax; programNo++)
                {
                    if (!instruments.ContainsKey(programNo))
                    {
                        items.Add(new NullInfo((Byte)programNo, (Byte)(programNo + 1)));
                        continue;
                    }

                    items.Add(instruments[programNo]);
                    hitCount++;

                    if (instruments.Count <= hitCount)
                    {
                        break;
                    }
                }
            }

            return items;
        }
    }
}
