﻿namespace NintendoWare.SoundFoundation.FileFormats.NintendoSdkBinary.WaveSound2Elements
{
    using NintendoWare.SoundFoundation.Binarization;
    using System.Collections.Generic;
    using System.Linq;
    using System.Runtime.InteropServices;

    /// <summary>
    /// INFO ブロック本体の構造を定義します。
    /// </summary>
    [StructLayout(LayoutKind.Sequential)]
    [DomElement(Tags = new string[] { "Element" })]
    internal class InfoBlockBody
    {
        private List<TrackBinary> tracks = new List<TrackBinary>();
        private List<ClipBinary> clips = new List<ClipBinary>();

        public InfoBlockBody()
        {
            this.TrackTable = new ReferenceTable<TrackBinary>()
            {
                Items = this.tracks,
            };
        }

        //-----------------------------------------------------------------
        // データ構造
        //-----------------------------------------------------------------

        /// <summary>
        /// トラックテーブルへのオフセットを出力するために、トラックテーブルへの参照を取得します。
        /// </summary>
        [DomObjectReference(OriginTag = "Element", HasOffset = true)]
        public ReferenceTable<TrackBinary> TrackTableReference
        {
            get { return this.TrackTable; }
        }

        /// <summary>
        /// トラックテーブルの実体を取得します。
        /// </summary>
        public ReferenceTable<TrackBinary> TrackTable { get; private set; }

        /// <summary>
        /// トラックの実体リストを取得します。
        /// </summary>
        public List<TrackBinary> Tracks
        {
            get { return this.tracks; }
        }

        /// <summary>
        /// クリップの実体列挙子を取得します。
        /// </summary>
        public IEnumerable<ClipBinary> Clips
        {
            get { return this.Tracks.SelectMany(track => track.ClipTable.Items); }
        }
    }
}
