﻿namespace NintendoWare.SoundFoundation.FileFormats.NintendoSdkBinary.WaveSound2Elements
{
    using System;
    using System.Runtime.InteropServices;

    /// <summary>
    /// クリップバイナリの構成を定義します。
    /// </summary>
    [StructLayout(LayoutKind.Sequential)]
    internal class ClipBinary
    {
        /// <summary>
        /// 波形インデックス
        /// </summary>
        public UInt32 WaveIndex { get; set; }

        /// <summary>
        /// 再生開始時間（ミリ秒）
        /// </summary>
        public UInt32 Position { get; set; }

        /// <summary>
        /// 再生時間（ミリ秒）
        /// TODO : 最期まで鳴らすことを示す数値が欲しい気がする ⇒ 0 ?
        /// </summary>
        public UInt32 Duration { get; set; }

        /// <summary>
        /// 波形の再生開始オフセット（サンプル数）
        /// </summary>
        public UInt32 StartOffset { get; set; }

        /// <summary>
        /// ピッチ
        /// </summary>
        public float Pitch { get; set; }

        /// <summary>
        /// 音量
        /// </summary>
        public byte Volume { get; set; }

        /// <summary>
        /// パン
        /// </summary>
        public byte Pan { get; set; }

        /// <summary>
        /// パディング
        /// </summary>
        public UInt16 Padding
        {
            get { return 0; }
        }
    }
}
