﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using Nintendo.Foundation.Contracts;
    using Projects;
    using System.Linq;

    internal static class SoundProjectEx
    {
        public static bool IsItemInSoundArchive(this SoundProject project, SoundSetItem targetItem)
        {
            Ensure.Argument.NotNull(project);
            Ensure.Argument.NotNull(targetItem);

            return project.SoundArchiveOutputTypes
                .Where(item => item.Key == targetItem.SoundSet)
                .Where(item => item.Value == SoundArchiveOutputTypes.SoundArchive)
                .Any();
        }

        public static bool IsItemInAddonSoundArchive(this SoundProject project, SoundSetItem targetItem)
        {
            Ensure.Argument.NotNull(project);
            Ensure.Argument.NotNull(targetItem);

            return project.SoundArchiveOutputTypes
                .Where(item => item.Key == targetItem.SoundSet)
                .Where(item => item.Value == SoundArchiveOutputTypes.AddonSoundArchive)
                .Any();
        }
    }
}
