﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using System.Collections.Generic;
    using Projects;
    using ToolDevelopmentKit;

    internal static class BankEx
    {
        public static IEnumerable<VelocityRegion> GetVelocityRegions(this Bank bank)
        {
            Ensure.Argument.NotNull(bank);

            foreach (Instrument instrument in bank.Children)
            {
                foreach (KeyRegion keyRegion in instrument.Children)
                {
                    foreach (VelocityRegion velocityRegion in keyRegion.Children)
                    {
                        yield return velocityRegion;
                    }
                }
            }
        }
    }
}
